/* 
 * Copyright 2011 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */



package org.sipdroid.media;

public class Resampler 
{
	int m_NumberStruct;
	
	Resampler(int NumberStruct, int SrcRate, int DestRate, int MaxSrcNum)
	{
		if (1 != Init (NumberStruct, SrcRate, DestRate, MaxSrcNum)) 
			android.util.Log.e("Resampler", "************  Resamplerinit Failed *************");
		m_NumberStruct = NumberStruct;
	};


	int doit(short DataSrc[], int SrcNum, int offset, short DestData[])
	{
		int ret = Doit (m_NumberStruct, DataSrc, SrcNum, offset, DestData); 
		return ret;
	};

	int silence(short Data[], int samples, long thresholdms, int samplerate, int maxsamplesdrop )
	{
		int ret = Silence (Data, samples, thresholdms, samplerate, maxsamplesdrop ); 
		return ret;
	};
	
	double energy(short Data[], int samples, long threshold )
	{
		double ret = Energy (Data, samples, threshold ); 
		return ret;
	};
	
	int dropsample(short Data[], int samples, int samplerate)
	{
		int ret = DropSample(Data, samples, samplerate); 
		return ret;
	};

	int setVolume (int NumberStruct, int SrcRate, int DestRate, int Factor)
	{
		int ret = SetVolume (NumberStruct, SrcRate, DestRate, Factor);
		//android.util.Log.e("Resampler", "*** Resample setVolume   -  NumberStruct:" +  NumberStruct + " Factor:"+ Factor + " SrcRate:" + SrcRate +" DestRate:"+ DestRate);
		return ret;
	};
	
	

	public native int Init (int NumberStruct, int SrcRate, int DestRate, int MaxSrcNum);
    public native int Doit (int NumberStruct, short DataSrc[], int SrcNum, int offset, short DestData[]);
	public native int SetVolume (int NumberStruct, int SrcRate, int DestRate, int Factor);

	public native int Silence (short Data[], int samples, long thresholdms, int samplerate, int maxsamplesdrop);
    public native double Energy  (short Data[], int samples, long threshold);
    public native int DropSample(short Data[], int samples, int samplerate);


    static {
    	System.loadLibrary("resample");
    }
}

