/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;

/* Soap implementation for the VoIP client interface */
public class SetVoIPConfClientInfo extends VoIPConfSoapHelper<Boolean>
{
	private int mIndex = 0;
	private String mPassword;
	private String mName;
	private String mId = null;
	private String mOutgoingNumber;
	
	public SetVoIPConfClientInfo(ISoapCredentials soapCredentials, int index,
			String password, String name, String outgoingNumber)
	{
		super(soapCredentials);
		mIndex = index;
		mPassword = password;
		mName = name;
		mOutgoingNumber = (outgoingNumber == null) ? "" : outgoingNumber;
	}

	public SetVoIPConfClientInfo(ISoapCredentials soapCredentials, int index,
			String password, String name, String outgoingNumber, String id)
	{
		this(soapCredentials, index, password, name, outgoingNumber);
		mId = id;
	}

	@Override
	public Boolean getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		String input = getSoapBody();
		
		// no out parameter, check for error response
		Matcher m = Pattern.compile("faultcode>(.*?)<\\/faultcode")
				.matcher(input);
		if (m.find())
			throw new DataMisformatException("Invalid Response from VoIPConf Service");

		return Boolean.TRUE;
	}

	@Override
	public String getSoapMethodParameter()
	{
		String params = "<NewX_AVM-DE_ClientIndex>" + Integer.toString(mIndex) + "</NewX_AVM-DE_ClientIndex>" +
				"<NewX_AVM-DE_ClientPassword>" + mPassword + "</NewX_AVM-DE_ClientPassword>" +
				"<NewX_AVM-DE_PhoneName>" + mName + "</NewX_AVM-DE_PhoneName>" +
				"<NewX_AVM-DE_OutGoingNumber>" + mOutgoingNumber + "</NewX_AVM-DE_OutGoingNumber>";
		if (mId != null)
			params += "<NewX_AVM-DE_ClientId>" + mId + "</NewX_AVM-DE_ClientId>";
		return params;
	}

	@Override
	protected String filterSoapBeforeTrace(String body)
	{
		StringBuilder builder = new StringBuilder();
		
		int pos = body.indexOf("<NewX_AVM-DE_ClientPassword>");
		if (pos > -1)
		{
			builder.append(body.substring(0, pos + 28));
			builder.append("SECRET");
			pos = body.indexOf("</NewX_AVM-DE_ClientPassword>", pos + 28);
			if (pos > -1) builder.append(body.substring(pos));
		}
		
		return builder.toString();
	}
	
	@Override
	public String getSoapMethod()
	{
		if (mId == null) return "X_AVM-DE_SetClient";
		return "X_AVM-DE_SetClient2";
	}
}