/*
 * Copyright (C) 2011 AVM GmbH <info@avm.de>
 * Copyright (C) 2009 The Sipdroid Open Source Project
 * Copyright (C) 2005 Luca Veltri - University of Parma - Italy
 * 
 * This file is part of MjSip (http://www.mjsip.org)
 * 
 * MjSip is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * MjSip is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MjSip; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Author(s):
 * Luca Veltri (luca.veltri@unipr.it)
 */

package org.zoolu.net;

import java.net.InetAddress;
import android.text.TextUtils;

import de.avm.android.fritzapp.util.InetAddressHelper;

/**
 * IpAddress is an IP address.
 */
public class IpAddress {

	/** The host address/name */
	String address;

	/** The InetAddress */
	InetAddress inet_address;

	/** Local IP address */
	private static String localIpAddress = null; // default is "127.0.0.1";
	
	// ********************* Protected *********************

	/** Creates an IpAddress */
	IpAddress(InetAddress iaddress) {
		init(null, iaddress);
	}

	/** Inits the IpAddress */
	private void init(String address, InetAddress iaddress) {
		this.address = address;
		this.inet_address = iaddress;
	}

	/** Gets the InetAddress */
	InetAddress getInetAddress() {
		if (inet_address == null)
			try {
				// ADO: we use v4 addresses only!
				inet_address = InetAddressHelper.getByName(address);
//				inet_address = InetAddress.getByName(address);
			} catch (java.net.UnknownHostException e) {
				inet_address = null;
			}
		return inet_address;
	}

	// ********************** Public ***********************

	/** Creates an IpAddress */
	public IpAddress(String address) {
		init(address, null);
	}

	/** Creates an IpAddress */
	public IpAddress(IpAddress ipaddr) {
		init(ipaddr.address, ipaddr.inet_address);
	}

	/** Gets the host address */
	/*
	 * public String getAddress() { if (address==null)
	 * address=inet_address.getHostAddress(); return address; }
	 */

	/** Makes a copy */
	public Object clone() {
		return new IpAddress(this);
	}

	/** Wthether it is equal to Object <i>obj</i> */
	public boolean equals(Object obj) {
		try {
			IpAddress ipaddr = (IpAddress) obj;
			if (!toString().equals(ipaddr.toString()))
				return false;
			return true;
		} catch (Exception e) {
			return false;
		}
	}

	/** Gets a String representation of the Object */
	public String toString() {
		if (address == null && inet_address != null)
			address = inet_address.getHostAddress();
		return address;
	}

	// *********************** Static ***********************

	/** Gets the IpAddress for a given fully-qualified host name. */
	public static IpAddress getByName(String host_addr)
			throws java.net.UnknownHostException {
		
		// ADO: we use v4 addresses only!
		InetAddress iaddr = InetAddressHelper.getByName(host_addr);
//		InetAddress iaddr = InetAddress.getByName(host_addr);
		return new IpAddress(iaddr);
	}

	public static String getLocalIpAddress()
	{
		return (TextUtils.isEmpty(localIpAddress)) ? "127.0.0.1" : localIpAddress;
	}
	
	/** Sets the local IP address into the variable <i>localIpAddress</i> */
	public static void setLocalIpAddress(String ipAddress)
	{
		localIpAddress = ipAddress;
	}
}
