/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents information about WLAN Config Info, as received from the FRITZ!box 
 */
public class WLANConfigInfo implements Parcelable
{
	/*
		NewEnable            		out Bool
		NewStatus        	 		out String "Up"
		NewMaxBitrate        		out String Auto
		NewChannel           		out ui1	11
		NewSSID             		out String SSID
		NewBeaconType       		out String "None", "Basic", "WPA", "11i", "WPAand11i"
		NewMACAddressControlEnabled out Bool
		NewStandard        			out String a, b, g, n 
		NewBSSID        			out String 
		NewBasicEncryptionModes     out String WEPEncryption, None   
		NewBasicAuthenticationMode  out String None
		NewMaxCharsSSID        		out ui1 32
		NewMinCharsSSID        		out ui1 3
		NewAllowedCharsSSID        	out String 01234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz !"#$...`{|}~(*) 
		NewMinCharsPSK        		out ui1 64
		NewMaxCharsPSK        		out ui1 64
		NewAllowedCharsPSK        	out String 01234567890ABCDEFabcdef
	*/

	private boolean mEnable 	= false;
	private String 	mStatus 	= "";
	private int  	mChannel 	= 0;
	private String	mSsid 		= "";
	private String	mBeaconType = "";
	private boolean mMACAddressControlEnabled = false;
	private String 	mStandard 	= "";
    private String  mBssid 		= "";
    private String  mBasicEncryptionModes = "";
    private String  mBasicAuthenticationMode = "";
    private StringSpec mSsidSpec = null;
    private StringSpec mPskSpec = null;

	@Override
	public String toString ()
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");

		result.append(this.getClass().getName()).append("Object {").append(NEW_LINE);
		result.append(" Enable: ").append(mEnable).append(NEW_LINE);
		result.append(" Status: ").append(mStatus).append(NEW_LINE);
		result.append(" Channel: ").append(mChannel).append(NEW_LINE);
		result.append(" Ssid: ").append(mSsid).append(NEW_LINE);
		result.append(" BeaconType: ").append(mBeaconType).append(NEW_LINE);
		result.append(" MACAddressControlEnabled: ").append(mMACAddressControlEnabled).append(NEW_LINE);
		result.append(" Standard: ").append(mStandard).append(NEW_LINE);
        result.append(" Bssid: ").append(mBssid).append(NEW_LINE);
        result.append(" BasicEncryptionModes: ").append(mBasicEncryptionModes).append(NEW_LINE);
        result.append(" BasicAuthenticationMode: ").append(mBasicAuthenticationMode).append(NEW_LINE);
		result.append("}");
		return result.toString();
	}
	
	public boolean isEnable()
	{
		return mEnable;
	}
	
	public void setEnable(boolean enable)
	{
		mEnable = enable;
	}
	
	public String getStatus() 
	{
		return mStatus;
	}
	
	public void setStatus(String status) 
	{
		mStatus = status;
	}
	
	public int getChannel()
	{
		return mChannel;
	}
	
	public void setChannel(int channel)
	{
		mChannel = channel;
	}
	
	public String getSsid()
	{
		return mSsid;
	}
	
	public void setSsid(String ssid)
	{
		mSsid = ssid;
	}
	
	public String getBeaconType()
	{
		return mBeaconType;
	}
	
	public void setBeaconType(String beaconType)
	{
		mBeaconType = beaconType;
	}
	
	public boolean isMACAddressControlEnabled()
	{
		return mMACAddressControlEnabled;
	}
	
	public void setMACAddressControlEnabled(boolean enabled)
	{
		mMACAddressControlEnabled = enabled;
	}
	
	public String getStandard()
	{
		return mStandard;
	}
	
	public void setStandard(String standard)
	{
		mStandard = standard;
	}
	
	public String getBssid()
	{
		return mBssid;
	}
	
	public void setBssid(String bssid)
	{
		mBssid = bssid;
	}

    public String getBasicEncryptionModes()
    {
        return mBasicEncryptionModes;
    }

    public void setBasicEncryptionModes(String basicEncryptionModes)
    {
        mBasicEncryptionModes = basicEncryptionModes;
    }

    public String getBasicAuthenticationMode()
    {
        return mBasicAuthenticationMode;
    }

    public void setBasicAuthenticationMode(String basicAuthenticationMode)
    {
        mBasicAuthenticationMode = basicAuthenticationMode;
    }

    public StringSpec getSsidSpec()
    {
        return mSsidSpec;
    }

    public void setSsidSpec(StringSpec ssidSpec)
    {
        mSsidSpec = ssidSpec;
    }

    public StringSpec getPskSpec()
    {
        return mPskSpec;
    }

    public void setPskSpec(StringSpec pskSpec)
    {
        mPskSpec = pskSpec;
    }

    public WLANConfigInfo()
	{
	}
	
	public WLANConfigInfo(Parcel in)
	{
		mEnable 	= in.readInt() != 0;
		mStatus 	= in.readString();
		mChannel	= in.readInt();
		mSsid 		= in.readString();
		mBeaconType = in.readString();
		mMACAddressControlEnabled = in.readInt() != 0;
		mStandard 	= in.readString();
		mBssid 		= in.readString();
        mBasicEncryptionModes = in.readString();
        mBasicAuthenticationMode = in.readString();
        mSsidSpec = in.readParcelable (null);
        mPskSpec = in.readParcelable (null);
	}

	public int describeContents()
	{
		return 0;
	}

	public static final Parcelable.Creator<WLANConfigInfo> CREATOR =
			new Parcelable.Creator<WLANConfigInfo>()
	{
		public WLANConfigInfo createFromParcel(Parcel in)
		{
			return new WLANConfigInfo(in);
		}

		public WLANConfigInfo[] newArray(int size)
		{
			return new WLANConfigInfo[size];
		}
	};

	public void writeToParcel(Parcel out, int flags)
	{
		out.writeInt((mEnable) ? 1 : 0);
		out.writeString(mStatus);
		out.writeInt(mChannel);
		out.writeString(mSsid);
		out.writeString(mBeaconType);
		out.writeInt((mMACAddressControlEnabled) ? 1 : 0);
		out.writeString(mStandard);
        out.writeString(mBssid);
        out.writeString(mBasicEncryptionModes);
        out.writeString(mBasicAuthenticationMode);
        out.writeParcelable(mSsidSpec, 0);
        out.writeParcelable(mPskSpec, 0);
	}
}